﻿using log4net;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Net;
using System.Threading.Tasks;
using System.Xml.Linq;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.Data;
using VA.PPMS.IWS.Api.Helpers;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;
using VA.PPMS.IWS.Common;

namespace VA.PPMS.IWS.Api.Controllers
{
    [Route("[controller]/v1")]
    public class PpmsDataStreamController : Controller
    {
        private readonly ILog _logger;
        private readonly IIwsConfiguration _configuration;
        private readonly IHttpClientHandler _client;

        public PpmsDataStreamController(ILog logger, IIwsConfiguration configuration, IHttpClientHandler client)
        {
            _logger = logger;
            _configuration = configuration;
            _client = client;
        }

        [HttpGet("{id}")]
        public async Task<IActionResult> Get(string id)
        {
            try
            {
                var urlId = Utilities.ValidateParameter(id);
                if (string.IsNullOrWhiteSpace(urlId)) return StatusCode(StatusCodes.Status400BadRequest);

                _logger.Info("@@@@@ Info - Start GET for PpmsDataStreamController @@@@@");

                var ppmsDataStreamUri = await _configuration.GetPpmsDataStreamUri();
                var queryString = $"{ppmsDataStreamUri}?id={urlId}";

                using (var response = await _client.GetAsync(queryString))
                {
                    if (response.IsSuccessStatusCode)
                    {
                        var returnStatus = await response.Content.ReadAsStringAsync();
                        XDocument xdoc = XDocument.Parse(returnStatus);

                        _logger.Info("@@@@@ Info - End GET for PpmsDataStreamController @@@@@");
                        return new XmlActionResult(xdoc); //StatusCode(StatusCodes.Status201Created);
                    }

                    _logger.Error($"PpmsDataStreamController: Error calling PpmsDataStream Api. Bad Status Returned: {response.StatusCode}");
                    var error = await response.Content.ReadAsStringAsync();
                    _logger.Error($"PpmsDataStreamController GET Exception. The error is {error}: {response}");

                    return StatusCode((int)response.StatusCode);
                }
            }
            catch (Exception ex)
            {
                _logger.Error("PpmsDataStreamController GET Exception:", ex);
                return StatusCode(StatusCodes.Status500InternalServerError);
            }
        }
    }
}